FILESEXTRAPATHS_prepend := "${THISDIR}/files:"
SRC_URI_append = " file://99_slaac.conf"
SRC_URI_append = " file://mmc.rules"
SRC_URI_append = " file://0001-Modified-to-have-ipv4-addresses-at-the-top-of-the-li.patch"

BBCLASSEXTEND_append = " native nativesdk"

PACKAGECONFIG_remove += "backlight"

# Override the default do_install for nativesdk build.
# Copy & pasted from ../openembedded-core/meta/recipes-core/systemd/systemd_230.bb, with a chown line removed

do_install_class-nativesdk() {
        autotools_do_install
        install -d ${D}/${base_sbindir}
        if ${@bb.utils.contains('PACKAGECONFIG', 'serial-getty-generator', 'false', 'true', d)}; then
                # Provided by a separate recipe
                rm ${D}${systemd_unitdir}/system/serial-getty* -f
        fi

        # Provide support for initramfs
        [ ! -e ${D}/init ] && ln -s ${rootlibexecdir}/systemd/systemd ${D}/init
        [ ! -e ${D}/${base_sbindir}/udevd ] && ln -s ${rootlibexecdir}/systemd/systemd-udevd ${D}/${base_sbindir}/udevd

        # Create machine-id
        # 20:12 < mezcalero> koen: you have three options: a) run systemd-machine-id-setup at install time, b) have / read-only and an empty file there (for stateless) and c) boot with / writable
        touch ${D}${sysconfdir}/machine-id


        install -d ${D}${sysconfdir}/udev/rules.d/
        install -d ${D}${sysconfdir}/tmpfiles.d
        install -m 0644 ${WORKDIR}/*.rules ${D}${sysconfdir}/udev/rules.d/
        install -d ${D}${libdir}/pkgconfig
        install -m 0644 ${B}/src/udev/udev.pc ${D}${libdir}/pkgconfig/

        install -m 0644 ${WORKDIR}/00-create-volatile.conf ${D}${sysconfdir}/tmpfiles.d/

        if ${@bb.utils.contains('DISTRO_FEATURES','sysvinit','true','false',d)}; then
                install -d ${D}${sysconfdir}/init.d
                install -m 0755 ${WORKDIR}/init ${D}${sysconfdir}/init.d/systemd-udevd
                sed -i s%@UDEVD@%${rootlibexecdir}/systemd/systemd-udevd% ${D}${sysconfdir}/init.d/systemd-udevd
        fi

        # Delete journal README, as log can be symlinked inside volatile.
        rm -f ${D}/${localstatedir}/log/README

        install -d ${D}${systemd_unitdir}/system/graphical.target.wants
        install -d ${D}${systemd_unitdir}/system/multi-user.target.wants
        install -d ${D}${systemd_unitdir}/system/poweroff.target.wants
        install -d ${D}${systemd_unitdir}/system/reboot.target.wants
        install -d ${D}${systemd_unitdir}/system/rescue.target.wants

        # Create symlinks for systemd-update-utmp-runlevel.service
        if ${@bb.utils.contains('PACKAGECONFIG', 'utmp', 'true', 'false', d)}; then
                ln -sf ../systemd-update-utmp-runlevel.service ${D}${systemd_unitdir}/system/graphical.target.wants/systemd-update-utmp-runlevel.service
                ln -sf ../systemd-update-utmp-runlevel.service ${D}${systemd_unitdir}/system/multi-user.target.wants/systemd-update-utmp-runlevel.service
                ln -sf ../systemd-update-utmp-runlevel.service ${D}${systemd_unitdir}/system/poweroff.target.wants/systemd-update-utmp-runlevel.service
                ln -sf ../systemd-update-utmp-runlevel.service ${D}${systemd_unitdir}/system/reboot.target.wants/systemd-update-utmp-runlevel.service
                ln -sf ../systemd-update-utmp-runlevel.service ${D}${systemd_unitdir}/system/rescue.target.wants/systemd-update-utmp-runlevel.service
        fi

        # Enable journal to forward message to syslog daemon
        sed -i -e 's/.*ForwardToSyslog.*/ForwardToSyslog=yes/' ${D}${sysconfdir}/systemd/journald.conf
        # Set the maximium size of runtime journal to 64M as default
        sed -i -e 's/.*RuntimeMaxUse.*/RuntimeMaxUse=64M/' ${D}${sysconfdir}/systemd/journald.conf

        # this file is needed to exist if networkd is disabled but timesyncd is still in use since timesyncd checks it
        # for existence else it fails
        if [ -s ${D}${exec_prefix}/lib/tmpfiles.d/systemd.conf ]; then
                ${@bb.utils.contains('PACKAGECONFIG', 'networkd', ':', 'sed -i -e "\$ad /run/systemd/netif/links 0755 root root -" ${D}${exec_prefix}/lib/tmpfiles.d/systemd.conf', d)}
        fi
        if ! ${@bb.utils.contains('PACKAGECONFIG', 'resolved', 'true', 'false', d)}; then
                # if resolved is disabled, it won't handle the link of resolv.conf, so
                # set it up ourselves
                ln -s ../run/resolv.conf ${D}${sysconfdir}/resolv.conf
                echo 'L! ${sysconfdir}/resolv.conf - - - - ../run/resolv.conf' >>${D}${exec_prefix}/lib/tmpfiles.d/etc.conf
                echo 'f /run/resolv.conf 0644 root root' >>${D}${exec_prefix}/lib/tmpfiles.d/systemd.conf
        fi
        install -Dm 0755 ${S}/src/systemctl/systemd-sysv-install.SKELETON ${D}${systemd_unitdir}/systemd-sysv-install
}

do_install_append() {
	install -d ${D}${sysconfdir}/sysctl.d
	install -m 644 ${WORKDIR}/99_slaac.conf ${D}${sysconfdir}/sysctl.d
	install -m 0644 ${WORKDIR}/mmc.rules ${D}${sysconfdir}/udev/rules.d/
	rm -f ${D}/${sysconfdir}/systemd/network/20-wired.network
	sed -i "s/Requires=.*/Requires=basic.target ui-init.target/g" ${D}${systemd_unitdir}/system/multi-user.target
	sed -i -e 's/.*RuntimeMaxUse=.*/RuntimeMaxUse=16M/g' ${D}${sysconfdir}/systemd/journald.conf
	sed -i -e 's/.*RuntimeMaxFileSize=.*/RuntimeMaxFileSize=8M/g' ${D}${sysconfdir}/systemd/journald.conf
	sed -i -e 's@\(kernel.panic\)\(.*\)@\1 = 3@' ${D}${sysconfdir}/sysctl.d/50-panic.conf
	sed -i -e '$akernel.panic_on_oops = 1' ${D}${sysconfdir}/sysctl.d/50-panic.conf
}

FILES_${PN}_remove = "${sysconfdir}/systemd/network/20-wired.network"

